// // // // // // // // // // // // // // // // // // // //
//	
//	Global Variables
//	
//	created Apr/14/98 by Andreas Warnke
//	last mod Apr/21/98 by Andreas Warnke
//	
//	Declaration of global Variables
//



// // // // // // // // // // // // // // // // // // // //
//	
//	#pragma once
//

#ifndef Global_h_
#define Global_h_



// // // // // // // // // // // // // // // // // // // //
//	
//	#include
//

#include <Be.h>
#include "FateMaker.h"



// // // // // // // // // // // // // // // // // // // //
//	
//	Global Variables declarations
//

//	Pointers to the loopers ( exept be_app ):
extern BLooper * TheStatusWindow;
extern BLooper * TheSimpleReflexAgent;

//	random integer generator:
extern FateMaker Fate;



// // // // // // // // // // // // // // // // // // // //
//	
//	Global Constants:
//	(Switch off Settings/C++ Language/Enums are Always Int)
//

//	Message - command types:
enum {
	eInterApplicationMessage = 0x87654321,
	eLoginButtonPressed = 0x87654330 };

//	Error Codes:
enum {
	eNoError = 0,
	//	Errors that mean "Client is not logged in":
	eServerRefusesLogin = -1,
	eIncompatibleVersions = -2,
	eMapTooSmall = -3,
	eOutOfMemoryNotLoggedIn = -4,
	eWrongPasswordNotLoggedIn = -5 };

//	Field Types:
enum {
	eEndOfWorld = 0x00,
	eInvisible = 0x08,
	eUndiscovered = 0x10,
	eSeaMin = 0x20,
	eSeaMax = 0x23,
	ePlainMin = 0x40,
	ePlainMax = 0x43,
	eForrestMin = 0x50,
	eForrestMax = 0x53,
	eMountainMin = 0x60,
	eMountainMax = 0x63 };

//	Object Types:
enum {
	eNoObject = 0x00,
	eCity = 0x20,
	eArmy = 0x30 };

//	MIME-Types
//	
//	The MIME-Type consists of a supertype and a subtype,
//	divided by a '/'.
//	the supertype of a program must be 'application',
//	the subtype should begin with 'x-vnd.'
#define eBasicAgentMIME "application/x-vnd.EnemyTerritory.BasicAgent"
#define eServerMIME "application/x-vnd.EnemyTerritory.Server"



#endif



//	
//	The End.
//	
// // // // // // // // // // // // // // // // // // // //